/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AbstractAthenaClient;
import com.amazonaws.athena.jdbc.AthenaNamespacesClient;
import com.amazonaws.athena.jdbc.AthenaResultSetUtils;
import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.CatalogColumnInfo;
import com.amazonaws.athena.jdbc.CatalogHierarchy;
import com.amazonaws.athena.jdbc.ColumnInfo;
import com.amazonaws.athena.jdbc.SQLPatternMatcher;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Table;
import com.amazonaws.athena.jdbc.shaded.guava.base.Preconditions;
import com.amazonaws.athena.jdbc.shaded.guava.collect.ImmutableList;
import com.amazonaws.athena.jdbc.shaded.guava.collect.Sets;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.lang.ArrayUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AthenaTableClient
extends AbstractAthenaClient {
    private final String catalogName;
    private final String namespaceName;
    private final String tableName;
    private final Set<String> tableTypes;
    private final AtomicReference<Iterator<CatalogHierarchy>> tableIterator = new AtomicReference();
    static final Comparator<CatalogHierarchy> sortComparator = new Comparator<CatalogHierarchy>(){

        @Override
        public int compare(CatalogHierarchy o1, CatalogHierarchy o2) {
            int tableTypeDiff = o1.getTable().getTableType().compareTo(o2.getTable().getTableType());
            if (tableTypeDiff != 0) {
                return tableTypeDiff;
            }
            int schemaDiff = o1.getCatalog().getCatalogName().compareTo(o2.getCatalog().getCatalogName());
            if (schemaDiff != 0) {
                return schemaDiff;
            }
            int namespaceDiff = o1.getNamespace().getName().compareTo(o2.getNamespace().getName());
            if (namespaceDiff != 0) {
                return namespaceDiff;
            }
            return o1.getTable().getName().compareTo(o2.getTable().getName());
        }
    };
    private final Set<CatalogHierarchy> results = new TreeSet<CatalogHierarchy>(sortComparator);
    private AtomicReference<Iterator<CatalogHierarchy>> resultsIterator = new AtomicReference();

    protected AthenaTableClient(AthenaServiceClient athenaServiceClient, String catalogName, String namespaceName, String tableName, String[] tableTypes) {
        super(athenaServiceClient);
        this.catalogName = catalogName;
        this.namespaceName = namespaceName;
        this.tableName = tableName;
        this.tableTypes = Sets.newHashSet(tableTypes == null ? ArrayUtils.EMPTY_STRING_ARRAY : tableTypes);
        this.tableIterator.set(this.iterator());
    }

    private synchronized List<CatalogHierarchy> getNextPage(int maxResults) throws SQLException {
        ArrayList<CatalogHierarchy> resultRows = new ArrayList<CatalogHierarchy>();
        Iterator<CatalogHierarchy> iterator = this.resultsIterator.get();
        for (int rowsProcessed = 0; (maxResults == 0 || rowsProcessed < maxResults) && iterator.hasNext(); ++rowsProcessed) {
            resultRows.add(iterator.next());
        }
        return resultRows;
    }

    private void getAllResultsAndSort() {
        Iterator<CatalogHierarchy> hierarchyIter = this.tableIterator.get();
        while (hierarchyIter.hasNext()) {
            if (this.cancelled.get()) {
                this.results.clear();
                break;
            }
            CatalogHierarchy catalogHierchary = hierarchyIter.next();
            if (!this.tableTypes.isEmpty() && !this.tableTypes.contains(catalogHierchary.getTable().getTableType())) continue;
            this.results.add(catalogHierchary);
        }
    }

    private void checkStarted() {
        boolean startedVal;
        if (!this.started.get() && !(startedVal = this.started.getAndSet(true))) {
            this.getAllResultsAndSort();
            this.resultsIterator = new AtomicReference<Iterator<CatalogHierarchy>>(this.results.iterator());
        }
    }

    @Override
    public List<ColumnInfo> getColumns() {
        return ImmutableList.of(CatalogColumnInfo.TABLE_CAT.cloneColumn(true), CatalogColumnInfo.TABLE_SCHEM.cloneColumn(true), CatalogColumnInfo.TABLE_NAME.getColumn(), CatalogColumnInfo.TABLE_TYPE.getColumn(), CatalogColumnInfo.REMARKS.getColumn(), CatalogColumnInfo.TYPE_CAT.cloneColumn(true), CatalogColumnInfo.TYPE_SCHEM.cloneColumn(true), CatalogColumnInfo.TYPE_NAME.cloneColumn(true), CatalogColumnInfo.SELF_REFERENCING_COL_NAME.cloneColumn(true), CatalogColumnInfo.REF_GENERATION.cloneColumn(true));
    }

    @Override
    public boolean hasNextQueryResult() {
        this.checkStarted();
        return this.resultsIterator.get().hasNext();
    }

    @Override
    public List<Row> nextQueryResult(int maxResults) throws SQLException {
        this.checkStarted();
        return this.getNextPage(maxResults).stream().map(hierarchy -> this.toResultRow((CatalogHierarchy)hierarchy)).collect(Collectors.toList());
    }

    private Row toResultRow(CatalogHierarchy next) {
        return new Row().withData(AthenaResultSetUtils.toDatum(next.getCatalog().getCatalogName()), AthenaResultSetUtils.toDatum(next.getNamespace().getName()), AthenaResultSetUtils.toDatum(next.getTable().getName()), AthenaResultSetUtils.toDatum(next.getTable().getTableType()), AthenaResultSetUtils.toDatum(""), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum(null), AthenaResultSetUtils.toDatum(null));
    }

    @Override
    public void cancel() {
        if (!this.cancelled.getAndSet(true)) {
            this.tableIterator.set(Collections.emptyIterator());
        }
    }

    public Iterator<CatalogHierarchy> getIterator() {
        return this.tableIterator.get();
    }

    Iterator<CatalogHierarchy> iterator() {
        TablesIterator tables = new TablesIterator(this.athenaServiceClient, this.catalogName, this.namespaceName, this.tableName);
        return tables;
    }

    public static class TablesIterator
    implements Iterator<CatalogHierarchy> {
        private final AthenaServiceClient serviceClient;
        private AthenaNamespacesClient.NamespaceIterator namespaceIter;
        private CatalogHierarchy currentNamespace;
        private Table currentTable;
        private final String tableName;
        private Iterator<Table> tableIter;
        private Pattern patternMatcher;

        public TablesIterator(AthenaServiceClient serviceClient, String catalogName, String namespaceName, String tableName) {
            this.serviceClient = serviceClient;
            AthenaNamespacesClient namespacesClient = new AthenaNamespacesClient(serviceClient, catalogName, namespaceName);
            this.namespaceIter = (AthenaNamespacesClient.NamespaceIterator)namespacesClient.getIterator();
            this.tableName = tableName;
            if (SQLPatternMatcher.hasWildCardCharacters(tableName)) {
                this.patternMatcher = SQLPatternMatcher.getSqlPattern(tableName);
            }
            if (this.namespaceIter.hasNext()) {
                this.currentNamespace = this.namespaceIter.next();
                this.tableIter = this.getNextPage();
                this.moveIterators();
            }
        }

        private Iterator<Table> getNextPage() {
            if (this.patternMatcher == null) {
                return this.serviceClient.getTables(this.currentNamespace.getCatalog().getCatalogId(), this.currentNamespace.getNamespace().getName(), SQLPatternMatcher.removeEscapeCharacters(this.tableName)).iterator();
            }
            List<Table> tables = this.serviceClient.getTables(this.currentNamespace.getCatalog().getCatalogId(), this.currentNamespace.getNamespace().getName(), null);
            return tables.stream().filter(table -> this.patternMatcher.matcher(table.getName()).matches()).collect(Collectors.toList()).iterator();
        }

        private void moveIterators() {
            if (this.tableIter.hasNext()) {
                this.currentTable = this.tableIter.next();
                return;
            }
            while (!this.tableIter.hasNext() && this.namespaceIter.hasNext()) {
                this.currentNamespace = this.namespaceIter.next();
                this.tableIter = this.getNextPage();
            }
            this.currentTable = this.tableIter.hasNext() ? this.tableIter.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.currentTable != null;
        }

        @Override
        public CatalogHierarchy next() {
            Preconditions.checkArgument(this.currentNamespace != null);
            CatalogHierarchy hierarchy = new CatalogHierarchy(this.currentNamespace.getCatalog(), this.currentNamespace.getNamespace(), this.currentTable);
            this.moveIterators();
            return hierarchy;
        }
    }
}

