/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AthenaConnection;
import com.amazonaws.athena.jdbc.AthenaResultSet;
import com.amazonaws.athena.jdbc.AthenaStatementClient;
import com.amazonaws.athena.jdbc.TimeLog;
import com.amazonaws.athena.jdbc.shaded.guava.annotations.VisibleForTesting;
import com.amazonaws.athena.jdbc.shaded.guava.primitives.Ints;
import com.amazonaws.athena.jdbc.shaded.org.apache.commons.lang3.exception.ExceptionUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AthenaStatement
implements Statement {
    private static final Logger LOGGER = LogManager.getLogger(AthenaStatement.class);
    private static final long BASE_SLEEP_DURATION_MS = 100L;
    private static final long MAX_SLEEP_DURATION_MS = 30000L;
    private static final int MAX_BACKOFF_FACTOR = 8;
    private final AtomicLong maxRows = new AtomicLong();
    private final AtomicInteger queryTimeoutSeconds = new AtomicInteger();
    private final AtomicInteger fetchSize = new AtomicInteger(0);
    private final AtomicBoolean escapeProcessing = new AtomicBoolean(true);
    private final AtomicBoolean closeOnCompletion = new AtomicBoolean();
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final AtomicReference<AthenaConnection> connection;
    private final AtomicReference<AthenaResultSet> currentResult = new AtomicReference();
    private final AtomicReference<AthenaStatementClient> runningClient = new AtomicReference();
    private final AtomicLong currentUpdateCount = new AtomicLong(-1L);
    private ReentrantLock lock = new ReentrantLock(true);

    AthenaStatement(AthenaConnection connection) {
        this.connection = new AtomicReference<AthenaConnection>(Objects.requireNonNull(connection, "connection is null"));
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("SQL statement is not a query: " + sql);
        }
        return this.currentResult.get();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return Ints.saturatedCast(this.executeLargeUpdate(sql));
    }

    @Override
    public void close() throws SQLException {
        this.connection.getAndSet(null);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        if (max < 0) {
            throw new SQLException("Max field size must be positive");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        long result = this.getLargeMaxRows();
        if (result > Integer.MAX_VALUE) {
            throw new SQLException("Max rows exceeds limit of 2147483647");
        }
        return Math.toIntExact(result);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows.get();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkOpen();
        if (max < 0L) {
            throw new SQLException("Max rows must be positive");
        }
        this.maxRows.set(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this.escapeProcessing.set(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeoutSeconds.get();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        if (seconds < 0) {
            throw new SQLException("Query timeout seconds must be positive");
        }
        this.queryTimeoutSeconds.set(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        if (!this.isCancelled.get()) {
            this.lock.lock();
            try {
                if (this.runningClient.get() != null) {
                    this.runningClient.get().cancel();
                    this.isCancelled.compareAndSet(false, true);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        TimeLog timeLog = new TimeLog();
        this.clearCurrentResults();
        this.checkOpen();
        AthenaStatementClient client = null;
        timeLog.addObservation("Finished Checking Connection. Starting Query: ");
        this.lock.lock();
        try {
            client = this.checkConnection().startQuery(sql);
            this.runningClient.set(client);
        }
        catch (Exception e) {
            LOGGER.error("Failed to run query: " + ExceptionUtils.getStackTrace(e), e);
            throw new SQLException("Failed to run query", e);
        }
        finally {
            this.lock.unlock();
        }
        timeLog.addObservation("Query Started.");
        AthenaResultSet resultSet = null;
        boolean operationComplete = false;
        int attempt = 0;
        try {
            while (!operationComplete) {
                this.lock.lock();
                try {
                    timeLog.addObservation("Checking Query Status");
                    client.getQueryStatus();
                    timeLog.addObservation("Finishing Checking Query Status");
                }
                finally {
                    this.lock.unlock();
                }
                if (client.isFailed()) {
                    LOGGER.error("Query " + client.getQueryExecutionId() + ", failed with reason " + client.getStateChangeReason() + " and state " + (Object)((Object)client.getQueryState()));
                    throw new SQLException(client.getStateChangeReason(), client.getQueryState().toString(), null);
                }
                if (client.isCancelled()) {
                    throw new SQLException("Query was cancelled");
                }
                if (client.isFinished()) {
                    operationComplete = true;
                } else {
                    timeLog.addObservation("Sleeping until we retry.");
                    Thread.sleep(AthenaStatement.getSleepDuration(attempt, client.getQueryStatusCheckBackoffInterval()));
                }
                ++attempt;
            }
            timeLog.addObservation("Query has Completed.");
            resultSet = new AthenaResultSet(client, this.maxRows.get(), this.fetchSize.get());
            this.currentResult.set(resultSet);
            timeLog.addObservation("Finished creating Result Set.");
            if (client.getUpdateType() != null && !client.getUpdateType().isEmpty()) {
                this.currentUpdateCount.set(client.getUpdateCount());
            }
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            LOGGER.error("Error executing query due to: " + ExceptionUtils.getStackTrace(e), e);
            throw new SQLException("Error executing query due to: " + ExceptionUtils.getStackTrace(e), e);
        }
        catch (InterruptedException e) {
            throw new SQLException("Query is interrupted", e);
        }
        finally {
            if (this.currentResult.get() == null && resultSet != null) {
                resultSet.close();
            }
            timeLog.addFinalObservation("Finished Executing query");
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.currentResult.get();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return Ints.saturatedCast(this.getLargeUpdateCount());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkOpen();
        return this.currentUpdateCount.get();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        if (this.currentResult.get() != null) {
            this.currentResult.get().close();
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (!AthenaStatement.validFetchDirection(direction)) {
            throw new SQLException("Invalid fetch direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Fetch size must be positive");
        }
        this.fetchSize.set(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize.get();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.checkConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        if (current == 1) {
            this.currentResult.get().close();
            return false;
        }
        if (current != 2 && current != 3) {
            throw new SQLException("Invalid argument: " + current);
        }
        throw new SQLFeatureNotSupportedException("Multiple open results not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("getGeneratedKeys");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw new SQLException("SQL is not an update statement: " + sql);
        }
        return this.currentUpdateCount.get();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.get() == null;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        this.closeOnCompletion.set(true);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return this.closeOnCompletion.get();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private void checkOpen() throws SQLException {
        this.checkConnection();
    }

    private AthenaConnection checkConnection() throws SQLException {
        AthenaConnection connection = this.connection.get();
        if (connection == null) {
            throw new SQLException("Statement is closed");
        }
        if (connection.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return connection;
    }

    private void clearCurrentResults() {
        this.currentResult.set(null);
        this.currentUpdateCount.set(-1L);
    }

    private static boolean validFetchDirection(int direction) {
        return direction == 1000;
    }

    @VisibleForTesting
    static long getSleepDuration(int attempt, int backoffInterval) {
        if (attempt < 0) {
            return 30000L;
        }
        int factor = attempt / backoffInterval + 1;
        if (factor > 8) {
            return 30000L;
        }
        return (long)Math.pow(2.0, factor) * 100L;
    }
}

