/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.AthenaStatementClient;
import java.io.Closeable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AthenaQueryExecutor
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger(AthenaQueryExecutor.class);
    private final AthenaServiceClient athenaServiceClient;

    public AthenaQueryExecutor(AthenaServiceClient athenaServiceClient) {
        this.athenaServiceClient = athenaServiceClient;
    }

    public AthenaStatementClient startQuery(String query, String schema) {
        String queryExecutionId = this.athenaServiceClient.runQuery(query, schema);
        LOGGER.info("Executing Query '" + query + "' with Execution ID: " + queryExecutionId);
        return new AthenaStatementClient(queryExecutionId, this.athenaServiceClient);
    }

    @Override
    public void close() {
        this.athenaServiceClient.close();
    }

    protected void finalize() {
        this.close();
    }
}

