/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AthenaConnection;
import com.amazonaws.athena.jdbc.AthenaDriverProperties;
import com.amazonaws.athena.jdbc.AthenaDriverPropertiesFactory;
import com.amazonaws.athena.jdbc.AthenaServiceClientConfig;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.athena.jdbc.shaded.guava.annotations.VisibleForTesting;
import com.amazonaws.athena.jdbc.shaded.guava.base.Strings;
import com.amazonaws.athena.jdbc.shaded.guava.base.Throwables;
import com.amazonaws.athena.jdbc.shaded.guava.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.SimpleLayout;

public class AthenaDriver
implements Driver,
Closeable {
    private static final org.apache.log4j.Logger LOGGER = LogManager.getLogger(AthenaDriver.class);
    static final int VERSION_MAJOR = 1;
    static final int VERSION_MINOR = 0;
    static final int JDBC_VERSION_MAJOR = 4;
    static final int JDBC_VERSION_MINOR = 1;
    static final String DRIVER_NAME = "Amazon Athena JDBC Driver";
    static final String DRIVER_VERSION = "1.0";
    private static final String JDBC_URL_START = "jdbc:";
    private static final String DRIVER_URL_START = "jdbc:awsathena:";
    private static final List<String> LOGGERS = ImmutableList.of("com.amazonaws.athena.jdbc.shaded.org.apache.commons.logging", "com.amazonaws.athena.jdbc.shaded.org.apache.http", "com.amazonaws.athena.jdbc.shaded.org.apache.commons.httpclient", "com.amazonaws.athena.jdbc.shaded.com.amazonaws");
    private static AtomicBoolean loggingEnabled = new AtomicBoolean(false);
    private final AthenaDriverPropertiesFactory propertiesFactory = new AthenaDriverPropertiesFactory();

    private static DriverPropertyInfo[] generateDriverProperties(Properties info) throws SQLException {
        ArrayList<DriverPropertyInfo> driverProperties = new ArrayList<DriverPropertyInfo>();
        for (AthenaDriverProperties property : AthenaDriverProperties.values()) {
            DriverPropertyInfo propertyInfo = new DriverPropertyInfo(property.getPropertyName(), null);
            propertyInfo.required = property.isRequired();
            propertyInfo.description = property.getDescription();
            propertyInfo.value = info.getProperty(property.getPropertyName(), property.getDefaultValue());
            driverProperties.add(propertyInfo);
            LOGGER.debug("Found Property : " + propertyInfo.name + " with value: " + propertyInfo.value);
        }
        return driverProperties.toArray(new DriverPropertyInfo[driverProperties.size()]);
    }

    @Override
    public void close() {
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        URI uri = AthenaDriver.parseDriverUrl(url);
        AthenaServiceClientConfig clientConfig = this.propertiesFactory.parseProperties(info, uri);
        AthenaDriver.processLogging(clientConfig);
        return new AthenaConnection(uri, clientConfig);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(DRIVER_URL_START);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return AthenaDriver.generateDriverProperties(info);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    public String getDriverName() throws SQLException {
        return DRIVER_NAME;
    }

    public String getDriverVersion() throws SQLException {
        return DRIVER_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @VisibleForTesting
    static URI parseDriverUrl(String url) throws SQLException {
        URI uri;
        try {
            uri = new URI(url.substring(JDBC_URL_START.length()));
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid JDBC URL: " + url, e);
        }
        if (Strings.isNullOrEmpty(uri.getHost())) {
            throw new SQLException("No host specified: " + url);
        }
        if (uri.getPort() == -1) {
            throw new SQLException("No port number specified: " + url);
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException("Invalid port number: " + url);
        }
        return uri;
    }

    private static synchronized void processLogging(AthenaServiceClientConfig config) throws SQLException {
        try {
            if (!StringUtils.isNullOrEmpty(config.getLogPath())) {
                if (!loggingEnabled.get()) {
                    RollingFileAppender appender = new RollingFileAppender(new SimpleLayout(), config.getLogPath(), true);
                    LogManager.getRootLogger().addAppender(appender);
                    loggingEnabled.set(true);
                }
                Level level = Level.toLevel(config.getLogLevel(), Level.INFO);
                for (String logger : LOGGERS) {
                    LogManager.getLogger(logger).setLevel(level);
                }
            }
        }
        catch (IOException e) {
            throw new SQLException("Unable to enable logging.", e);
        }
    }

    static {
        try {
            DriverManager.registerDriver(new AthenaDriver());
        }
        catch (SQLException e) {
            throw Throwables.propagate(e);
        }
    }

    static interface UpdateClientConfig {
        public void update(String var1) throws SQLException;
    }
}

