/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AbstractAthenaClient;
import com.amazonaws.athena.jdbc.AthenaResultSetUtils;
import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.CatalogColumnInfo;
import com.amazonaws.athena.jdbc.ColumnInfo;
import com.amazonaws.athena.jdbc.SQLPatternMatcher;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Catalog;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AthenaCatalogClient
extends AbstractAthenaClient {
    private final String catalogName;
    private AtomicReference<Iterator<Catalog>> catalogIterator = new AtomicReference();

    protected AthenaCatalogClient(AthenaServiceClient athenaServiceClient, String catalogName) {
        super(athenaServiceClient);
        this.catalogName = catalogName;
        this.catalogIterator.set(this.iterator());
    }

    @Override
    public List<ColumnInfo> getColumns() {
        return Arrays.asList(CatalogColumnInfo.TABLE_CAT).stream().map(enumVal -> enumVal.getColumn()).collect(Collectors.toList());
    }

    @Override
    public boolean hasNextQueryResult() {
        if (!this.started.get()) {
            return true;
        }
        return this.catalogIterator.get().hasNext();
    }

    public List<Catalog> getNextPage(int maxResults) throws SQLException {
        Iterator<Catalog> catalogIter = this.catalogIterator.get();
        ArrayList<Catalog> resultRows = new ArrayList<Catalog>();
        for (int rowsProcessed = 0; (maxResults == 0 || rowsProcessed < maxResults) && catalogIter.hasNext() && !this.closed.get(); ++rowsProcessed) {
            resultRows.add(catalogIter.next());
        }
        return resultRows;
    }

    @Override
    public List<Row> nextQueryResult(int maxResults) throws SQLException {
        return this.getNextPage(maxResults).stream().map(catalog -> this.toResultRow((Catalog)catalog)).collect(Collectors.toList());
    }

    private Row toResultRow(Catalog catalogName) {
        return new Row().withData(AthenaResultSetUtils.toDatum(catalogName.getCatalogName()));
    }

    @Override
    public void cancel() {
        if (!this.cancelled.getAndSet(true)) {
            this.catalogIterator.set(Collections.emptyIterator());
        }
    }

    public Iterator<Catalog> getIterator() {
        return this.catalogIterator.get();
    }

    protected CatalogIterator iterator() {
        return new CatalogIterator(this.athenaServiceClient, this.catalogName);
    }

    public static class CatalogIterator
    implements Iterator<Catalog> {
        private Iterator<Catalog> catalogIter;

        public CatalogIterator(AthenaServiceClient athenaServiceClient, String catalogName) {
            if (catalogName == null) {
                this.catalogIter = athenaServiceClient.getCatalogs().iterator();
            } else if (SQLPatternMatcher.hasWildCardCharacters(catalogName)) {
                Pattern pattern = SQLPatternMatcher.getSqlPattern(catalogName);
                this.catalogIter = athenaServiceClient.getCatalogs().stream().filter(catalog -> pattern.matcher(catalog.getCatalogName()).matches()).collect(Collectors.toList()).iterator();
            } else {
                this.catalogIter = athenaServiceClient.getCatalogs(SQLPatternMatcher.removeEscapeCharacters(catalogName)).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.catalogIter.hasNext();
        }

        @Override
        public Catalog next() {
            return this.catalogIter.next();
        }
    }
}

