/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.jdbc;

import com.amazonaws.athena.jdbc.AthenaServiceClient;
import com.amazonaws.athena.jdbc.ColumnInfo;
import com.amazonaws.athena.jdbc.shaded.com.amazonaws.services.athena.model.Row;
import java.sql.SQLException;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractAthenaClient {
    protected final AthenaServiceClient athenaServiceClient;
    protected volatile String currentNextToken;
    protected final AtomicBoolean started;
    protected final AtomicBoolean closed;
    protected final AtomicBoolean cancelled;
    protected volatile List<ColumnInfo> columns;

    protected AbstractAthenaClient(AthenaServiceClient athenaServiceClient) {
        this.athenaServiceClient = athenaServiceClient;
        this.started = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.cancelled = new AtomicBoolean(false);
        this.currentNextToken = null;
    }

    public AthenaServiceClient getAthenaServiceClient() {
        return this.athenaServiceClient;
    }

    public boolean hasNextQueryResult() {
        if (!this.started.get()) {
            return true;
        }
        return this.currentNextToken != null;
    }

    abstract List<Row> nextQueryResult(int var1) throws SQLException;

    public void cancel() {
        this.cancelled.compareAndSet(false, true);
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        this.closed.compareAndSet(false, true);
    }

    public String getTimeZoneId() {
        return TimeZone.getDefault().getID();
    }
}

